/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#include <stdlib.h>
#include <drmcommon.h>

DRM_VOID drmtype_asserts(void)
{
    DRMSIZEASSERT(sizeof(DRM_BYTE), 1);
    DRMSIZEASSERT(sizeof(DRM_CHAR), 1);
#if SIXTEEN_BIT_ADDRESSING
    DRMSIZEASSERT(sizeof (DRM_SHORT), 1);
    DRMSIZEASSERT(sizeof (DRM_WORD),  1);
    DRMSIZEASSERT(sizeof (DRM_UINT),  2);
    DRMSIZEASSERT(sizeof (DRM_INT),   2);
    DRMSIZEASSERT(sizeof (DRM_LONG),  2);
    DRMSIZEASSERT(sizeof (DRM_DWORD), 2);
    DRMSIZEASSERT(sizeof (DRM_INT64), 4);
#else
    #if !defined(__unix__)
    DRMSIZEASSERT(sizeof (DRM_SHORT), 2);
    DRMSIZEASSERT(sizeof (DRM_WORD),  2);
    #endif
    DRMSIZEASSERT(sizeof (DRM_UINT),  4);
    DRMSIZEASSERT(sizeof (DRM_INT),   4);
    DRMSIZEASSERT(sizeof (DRM_LONG),  4);
    DRMSIZEASSERT(sizeof (DRM_DWORD), 4);
    DRMSIZEASSERT(sizeof (DRM_INT64), 8);
#endif    
}

extern DRM_VOID DRM_API 
_oem_trace(IN DRM_CHAR* szFmt, ...);


/*****************************************************************************/
fncdrmtrace g_TraceCallback = _oem_trace;

/*****************************************************************************/
DRM_VOID DRM_API DrmDebugHookTrace(IN fncdrmtrace pNewAssertFcn)
{
#if DBG
    if(NULL == pNewAssertFcn)
    {
        g_TraceCallback = _oem_trace;
    }
    else
    {
        g_TraceCallback = pNewAssertFcn;
    }
#endif
}

#if DBG

/*****************************************************************************/
DRM_VOID DRM_API __drmassert(
    IN DRM_BOOL  fAssert, 
    IN DRM_CHAR *assertcmd, 
    IN DRM_CHAR *file, 
    IN DRM_INT   line)
{

	if(!fAssert) 
	{ 
		g_TraceCallback("DRMASSERT %s failed.  File %s. Line %d.\n",assertcmd,file,line);        
        if( g_OEMAssertCallback != NULL )
        {
            g_OEMAssertCallback( fAssert, assertcmd, file, line );
        }
	}	
} 


/*****************************************************************************/
/* Set the global assert handler to the above function */
fncdrmassert g_AssertCallback = __drmassert;

#endif

/*****************************************************************************/
DRM_VOID DRM_API DrmDebugHookAssert(IN fncdrmassert pNewAssertFcn)
{
#if DBG
    if(NULL == pNewAssertFcn)
    {
        g_AssertCallback = __drmassert;
    }
    else
    {
        g_AssertCallback = pNewAssertFcn;
    }
#endif
}


